/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.facade.NewsRecommendFeignService;
import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.param.ForumParam;
import com.bxm.localnews.param.MixRecommendParam;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class NewsRecommendIntegrationService {
    private final NewsRecommendFeignService newsRecommendFeignService;

    @Autowired
    public NewsRecommendIntegrationService(NewsRecommendFeignService newsRecommendFeignService) {
        this.newsRecommendFeignService = newsRecommendFeignService;
    }

    public List<Long> recommendList(Long userId, Integer kindId, Integer pageSize, String areaCode, Integer curPage) {
        ResponseEntity<List<Long>> result = this.newsRecommendFeignService.recommendList(userId, kindId, pageSize, areaCode, curPage);
        if (null == result) {
            return Lists.newArrayList();
        }
        return (List)result.getBody();
    }

    public List<Long> recommendByNewsDetail(Long newsId, Long userId, Integer size) {
        ResponseEntity<List<Long>> result = this.newsRecommendFeignService.recommendByNewsDetail(newsId, userId, size);
        if (null == result) {
            return Lists.newArrayList();
        }
        return (List)result.getBody();
    }

    public List<VideoDto> recommendVideoList(Long userId, Integer pageSize) {
        ResponseEntity<List<VideoDto>> result = this.newsRecommendFeignService.recommendVideoList(userId, pageSize);
        if (null == result) {
            return Lists.newArrayList();
        }
        return (List)result.getBody();
    }

    public List<Long> recommendList(ForumParam forumParam) {
        ResponseEntity<List<Long>> result = this.newsRecommendFeignService.recommendList(forumParam);
        if (null == result) {
            return Lists.newArrayList();
        }
        return (List)result.getBody();
    }

    public List<MixRecommendDTO> listMixRecommendDTO(MixRecommendParam mixRecommendParam) {
        ResponseEntity<List<MixRecommendDTO>> result = this.newsRecommendFeignService.listMixRecommend(mixRecommendParam);
        if (null == result) {
            return Lists.newArrayList();
        }
        return (List)result.getBody();
    }

    public void cleanUserTop(Long userId, Long postId) {
        this.newsRecommendFeignService.cleanUserTop(userId, postId);
    }
}

