package com.bxm.localnews.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "首页推荐逻辑返回封装参数")
public class MixRecommendDTO extends BaseBean {

    @ApiModelProperty("新闻id或帖子id")
    private Long id;

    @ApiModelProperty("来源 1：社区帖子 2：本地新闻 3：全国新闻")
    private String  origin;

    public static MixRecommendDTO build(Long id,String origin){
        MixRecommendDTO mixRecommendDTO = new MixRecommendDTO();
        mixRecommendDTO.setId(id);
        mixRecommendDTO.setOrigin(origin);
        return mixRecommendDTO;
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
}