package com.bxm.localnews.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "用户实体")
@Data
public class User extends BaseBean {

    @ApiModelProperty("用户ID，同时也是用户的邀请码。如果是注册绑定则传递静默注册用户ID")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户密码")
    private String password;

    @ApiModelProperty("用户手机号码")
    private String phone;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty(hidden = true)
    private int age;

    @ApiModelProperty(hidden = true)
    private Byte sex;

    @ApiModelProperty(hidden = true)
    private Byte level;

    @ApiModelProperty(hidden = true)
    private String weixin;

    @ApiModelProperty(hidden = true)
    private String qq;

    @ApiModelProperty(hidden = true)
    private String weibo;

    @ApiModelProperty(hidden = true)
    private Byte state;

    @ApiModelProperty(hidden = true)
    private String registerClient;

    @ApiModelProperty("手机型号")
    private String phoneModel;

    @ApiModelProperty("设备号")
    private String equipment;

    @ApiModelProperty("注册地址")
    private String registeredAddress;

    @ApiModelProperty("生日(精确到日) [注册不需传]")
    private Date birthday;

    @ApiModelProperty("定位区域编码 [注册不需传]")
    private String locationCode;

    @ApiModelProperty("定位区域名称 [注册不需传默认为北京]")
    private String locationName;
}