package com.bxm.localnews.facade;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.facade.fallback.AppVersionFallbackFactory;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(value = "localnews", fallbackFactory = AppVersionFallbackFactory.class)
public interface AppVersionFeignService {

    @GetMapping("/facade/app/version/state")
    ResponseEntity<Boolean> getPublishState(@RequestBody BasicParam basicParam);

    @GetMapping("/facade/app/version/judge")
    ResponseEntity<Integer> judgeCurVersion(@RequestParam("curVer") String curVer, @RequestParam("version") String version);
}
