package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.BizLogFallbackFactory;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 业务日志记录服务接口
 */
@FeignClient(value = "localnews", fallbackFactory = BizLogFallbackFactory.class)
public interface BizLogFeignService {

    @PostMapping("facade/biz/log/forumSuccessed")
    void forumSuccessed(@RequestParam("userId") Long userId,
                        @RequestParam(value = "areaCode", required = false) String areaCode,
                        @RequestParam("platform") Integer platform);

    @PostMapping("facade/biz/log/replySuccessed")
    void replySuccessed(@RequestParam("userId") Long userId, @RequestParam("id") Long id,
                        @RequestParam("type") Integer type, @RequestParam(value = "areaCode", required = false) String areaCode,
                        @RequestParam("platform") Integer platform);

    @PostMapping("facade/biz/log/shareForumSuccessed")
    void shareForumSuccessed(@RequestParam("userId") Long userId, @RequestParam("id") Long id,
                             @RequestParam(value = "areaCode", required = false) String areaCode,
                             @RequestParam("platform") Integer platform);

    @PostMapping("facade/biz/log/forumLikeSuccessed")
    void forumLikeSuccessed(@RequestParam("userId") Long userId, @RequestParam("id") Long id,
                            @RequestParam(value = "areaCode", required = false) String areaCode,
                            @RequestParam("platform") Integer platform);

    @PostMapping("facade/biz/log/forumCollectSuccessed")
    void forumCollectSuccessed(@RequestParam("userId") Long userId, @RequestParam("id") Long id,
                               @RequestParam(value = "areaCode", required = false) String areaCode,
                               @RequestParam("type") Integer type,
                               @RequestParam("platform") Integer platform);
}
