package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.MessageFallbackFactory;
import com.bxm.localnews.mq.common.model.dto.PushMessage;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/3/1 10:13
 * @desc
 */
@FeignClient(value = "localnews-msg", fallbackFactory = MessageFallbackFactory.class)
public interface MessageFeignService {

    @PostMapping("/facade/msg/add")
    ResponseEntity<Boolean> addMessage(@RequestBody PushMessage pushMessage, @RequestParam("userId") Long userId);
}
