package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.MissionFallbackFactory;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.SignCompleTaskDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews", fallbackFactory = MissionFallbackFactory.class)
public interface MissionFeignService {

    @PostMapping("/facade/activity/mission/comple")
    ResponseEntity<NewsCompleTaskDTO> compleTask(@RequestParam("userId") Long userId,
                                                 @RequestParam("taskName") String taskName,
                                                 @RequestParam(value = "relationId", required = false) String relationId,
                                                 @RequestParam(value = "content") String  content );

    @PostMapping("/facade/activity/mission/comple")
    ResponseEntity<SignCompleTaskDTO> signCompleTask(@RequestParam("userId") Long userId,
                                                 @RequestParam("taskName") String taskName,
                                                 @RequestParam(value = "relationId", required = false) String relationId,
                                                 @RequestParam(value = "content") String  content );
}
