package com.bxm.localnews.facade;

import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.facade.fallback.NewsRecommendFallbackFactory;
import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.param.ForumParam;
import com.bxm.localnews.param.MixRecommendParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(value = "localnews-recommend", fallbackFactory = NewsRecommendFallbackFactory.class)
public interface NewsRecommendFeignService {
    @GetMapping(value = "api/news/recommendList")
    ResponseEntity<List<Long>> recommendList(@RequestParam("userId") Long userId,
                                             @RequestParam(value = "kindId", required = false) Integer kindId,
                                             @RequestParam("pageSize") Integer pageSize,
                                             @RequestParam(value = "areaCode", required = false) String areaCode,
                                             @RequestParam(value = "curPage") Integer curPage);

    @GetMapping(value = "api/news/recommendByNewsDetail")
    ResponseEntity<List<Long>> recommendByNewsDetail(@RequestParam(value = "newsId") Long newsId,
                                                     @RequestParam(value = "userId") Long userId,
                                                     @RequestParam(value = "size",required = false) Integer size,
                                                     @RequestParam(value = "platform",required = false) Integer platform);

    @GetMapping(value = "api/video/recommendList")
    ResponseEntity<List<VideoDto>> recommendVideoList(@RequestParam(value = "userId") Long userId,
                                                      @RequestParam(value = "pageSize") Integer pageSize);

    @PostMapping(value = "api/forum/recommendList")
    ResponseEntity<List<Long>> recommendList(@RequestBody ForumParam forumParam);

    /**
     *
     * 调用[推荐引擎]接口获取首页推荐结果
     * @param mixRecommendParam
     * @return id 和 来源
     */
    @GetMapping(value = "api/index/mixRecommendList")
    ResponseEntity<List<MixRecommendDTO>> listMixRecommend(@RequestBody MixRecommendParam mixRecommendParam);

    /**
     * 在用户删除时将其置顶的帖子删除
     * @param userId
     * @param postId
     * @return
     */
    @DeleteMapping(value = "api/forum/userTop/cache")
    ResponseEntity cleanUserTop(@RequestParam("userId")Long userId,@RequestParam("postId") Long postId);
}
