package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.NewsSearchFallbackFactroy;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-search", fallbackFactory = NewsSearchFallbackFactroy.class)
public interface NewsSearchFeignService {

    @GetMapping(value = "api/news/search/get")
    ResponseEntity<List<NewsVO>> multipleGet(@RequestParam("ids") Long[] ids);

    @GetMapping(value = "api/news/search/list")
    ResponseEntity<List<News>> listRecommendedNews(@RequestParam("ids") Long[] ids);

    @GetMapping(value = "api/news/search/top")
    ResponseEntity<List<News>> listTopNews(@RequestParam("size") Integer size,@RequestParam(value = "areaCode",required = false) String areaCode);

}
