package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.NewsSyncFallbackFactory;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.vo.NewsRecommended;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(value = "localnews-spider-sync", fallbackFactory = NewsSyncFallbackFactory.class)
public interface NewsSyncFeignService {

     @PostMapping(value = "api/news/sync/recommended")
     ResponseEntity generateRecommeded(@RequestBody List<NewsRecommended> newsRecommendedList);

     @PostMapping(value = "api/news/manage/save")
     ResponseEntity save(@RequestBody News news);

     @PostMapping(value = "api/news/status/update")
     ResponseEntity updateStatus(@RequestBody News news);
}
