package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.PushMsgSupplyFallbackFactory;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.news.param.VideoBlackParam;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.param.VideoViewParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-msg", fallbackFactory = PushMsgSupplyFallbackFactory.class)
public interface PushMsgSupplyFeignService {

    @PostMapping("/push")
    void pushMsg(@RequestBody PushMessage message);

    /******************************************新闻静态数据发送********************************************************/

    @PostMapping("/facade/news/statistic/share")
    void pushShareData(@RequestParam(value = "userId") Long userId,
                       @RequestParam(value = "newsId") Long newsId);

    @PostMapping("/facade/news/statistic/view")
    void pushViewData(@RequestParam(value = "userId") Long userId,
                      @RequestParam(value = "newsId") Long newsId);

    @PostMapping("/facade/news/statistic/activeView")
    void pushActiveViewData(@RequestParam(value = "userId") Long userId,
                      @RequestParam(value = "newsId") Long newsId);

    @PostMapping("/facade/news/statistic/newClick")
    void pushNewClickData(@RequestParam(value = "userId") Long userId,
                          @RequestParam(value = "newsId") Long newsId);

    @PostMapping("/facade/news/statistic/collect")
    void pushCollectData(@RequestParam(value = "userId") Long userId,
                         @RequestParam(value = "newsId") Long newsId,
                         @RequestParam(value = "type") Byte type);

    @PostMapping("/facade/news/statistic/comment")
    void pushCommentData(@RequestParam(value = "userId") Long userId,
                         @RequestParam(value = "newsId") Long newsId);

    /******************************************视频静态数据发送********************************************************/

    @PostMapping("/facade/video/statistic/black")
    void pushVideoBlackData(@RequestBody VideoBlackParam videoBlackParam);

    @PostMapping("/facade/video/statistic/share")
    void pushVideoShareData(@RequestBody VideoShareParam videoShareParam);

    @PostMapping("/facade/video/statistic/view")
    void pushVideoViewData(@RequestBody VideoViewParam videoViewParam);

    @PostMapping("/facade/video/statistic/comment")
    void pushVideoCommentData(@RequestParam("userId") Long userId,
                             @RequestParam(value = "newsId") Long newsId);

    /******************************************帖子静态数据发送********************************************************/

    @PostMapping("/facade/post/statistic/recommended")
    void pushPostRecommededData(@RequestParam("userId") Long userId,
                                @RequestParam(value = "postIds") List<Long> postIds);

    @PostMapping("/facade/post/statistic/activeView")
    void pushPostActiveViewData(@RequestParam(value = "userId") Long userId,
                                @RequestParam(value = "postId") Long postId);

    @PostMapping("/facade/post/statistic/click")
    void pushPostClickData(@RequestParam(value = "userId") Long userId,
                           @RequestParam(value = "postId") Long postId);



}
