package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.QuartzIntegrationFallbackFactory;
import com.bxm.localnews.news.param.UserTopPostBuildParam;
import com.bxm.localnews.param.AddPostClickCountParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(value = "localnews-quartz", fallbackFactory = QuartzIntegrationFallbackFactory.class)
@RequestMapping("quartz")
public interface QuartzIntegrationService {

    /**
     * 构建用户帖子置顶的定时任务
     * @param param
     * @return
     */
    @PostMapping("/remove/user/post")
    ResponseEntity<String> removePostUserTopTask(@RequestBody UserTopPostBuildParam param);

    /**
     * 添加定时增加帖子点击数的定时任务(仅运行一天)
     *
     * @param param
     * @return
     */
    @PostMapping("/add/postClick")
    ResponseEntity<String> createPostClickTask(@RequestBody AddPostClickCountParam param);

}
