package com.bxm.localnews.facade;

import com.bxm.localnews.dto.User;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.vo.VirtualUserInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@FeignClient(value = "localnews-user", fallbackFactory = UserFallbackFactory.class)
public interface UserFeignService {

    /**
     * 获取用户详细信息
     * @param userId
     * @return
     */
    @GetMapping(value = "facade/user/info")
    ResponseEntity<UserBean> selectUserFromCache(@RequestParam("userId") Long userId);


    /**
     * 帖子、评论数修改
     * @param userId
     * @param type 1帖子+1 2帖子-1 3评论+1 4评论-1
     * @return
     */
    @PostMapping("facade/user/addPostReplyNum")
    ResponseEntity<Boolean> addPostReplyNum(@RequestParam("userId") Long userId, @RequestParam("type") Integer type);

    /**
     * 获得虚拟用户
     * @param num
     * @return
     */
    @PostMapping("facade/user/getVirtualUserList")
    ResponseEntity<List<VirtualUserInfo>> getVirtualUserList(@RequestParam("num") Integer num);
}
