package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.facade.AppVersionFeignService;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class AppVersionFallbackFactory implements FallbackFactory<AppVersionFeignService> {
    @Override
    public AppVersionFeignService create(Throwable throwable) {
        return new AppVersionFeignService() {

            @Override
            public ResponseEntity<Boolean> getPublishState(BasicParam basicParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Integer> judgeCurVersion(String curVer, String version) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(-1);
            }
        };
    }
}
