package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.BizLogFeignService;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/2/28 17:49
 * @desc
 */
@Component
@Slf4j
public class BizLogFallbackFactory implements FallbackFactory<BizLogFeignService> {
    @Override
    public BizLogFeignService create(Throwable throwable) {
        return new BizLogFeignService() {
            @Override
            public void forumSuccessed(Long userId, String areaCode, Integer platform) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void replySuccessed(Long userId, Long id, Integer type, String areaCode, Integer platform) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void shareForumSuccessed(Long userId, Long id, String areaCode, Integer platform) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void forumLikeSuccessed(Long userId, Long id, String areaCode, Integer platform) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void forumCollectSuccessed(Long userId, Long id, String areaCode, Integer type, Integer platform) {
                log.error(throwable.getMessage(), throwable);
            }
        };
    }
}

