package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.DingtalkPushService;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DingtalkPushFallbackFactory implements FallbackFactory<DingtalkPushService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(DingtalkPushFallbackFactory.class);

    @Override
    public DingtalkPushService create(Throwable throwable) {
        return new DingtalkPushService() {
            @Override
            public void push(String content) {
                LOGGER.error(throwable.getMessage(), throwable);
            }
        };
    }
}
