package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.MessageFeignService;
import com.bxm.localnews.mq.common.model.dto.PushMessage;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/1 10:12
 * @desc
 */
@Component
@Slf4j
public class MessageFallbackFactory implements FallbackFactory<MessageFeignService> {

    @Override
    public MessageFeignService create(Throwable throwable) {
        return new MessageFeignService() {

            @Override
            public ResponseEntity<Boolean> addMessage(PushMessage pushMessage, Long userId) {
                return ResponseEntity.ok(Boolean.FALSE);
            }
        };
    }
}
