package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.MissionFeignService;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.SignCompleTaskDTO;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class MissionFallbackFactory implements FallbackFactory<MissionFeignService> {

    @Override
    public MissionFeignService create(Throwable throwable) {
        return new MissionFeignService() {

            @Override
            public ResponseEntity<NewsCompleTaskDTO> compleTask(Long userId, String taskName, String relationid, String content) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new NewsCompleTaskDTO());
            }

            @Override
            public ResponseEntity<SignCompleTaskDTO> signCompleTask(Long userId, String taskName, String relationId, String content) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new SignCompleTaskDTO());
            }
        };
    }
}
