package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.facade.NewsRecommendFeignService;
import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.param.ForumParam;
import com.bxm.localnews.param.MixRecommendParam;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class NewsRecommendFallbackFactory implements FallbackFactory<NewsRecommendFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsRecommendFallbackFactory.class);

    @Override
    public NewsRecommendFeignService create(Throwable throwable) {
        return new NewsRecommendFeignService() {
            @Override
            public ResponseEntity<List<Long>> recommendList(Long userId, Integer kindId, Integer pageSize, String areaCode,Integer curPage) {
                //记录请求参数
                LOGGER.error("recommendList:userId:{},kindId:{},pageSize:{},areaCode:{},curPage:{}", userId, kindId, pageSize, areaCode,curPage);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }


            @Override
            public ResponseEntity<List<Long>> recommendByNewsDetail(Long newsId, Long userId,Integer size, Integer platform) {
                LOGGER.error("recommendByNewsDetail,newsId:{},userId:{}", newsId, userId);
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<List<VideoDto>> recommendVideoList(Long userId, Integer pageSize) {
                LOGGER.error("recommendVideoList,newsId:{},userId:{}", userId, pageSize);
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<List<Long>> recommendList(ForumParam forumParam) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<List<MixRecommendDTO>> listMixRecommend(MixRecommendParam mixRecommendParam) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity cleanUserTop(Long userId, Long postId) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}
