package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.NewsSyncFeignService;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.vo.NewsRecommended;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class NewsSyncFallbackFactory implements FallbackFactory<NewsSyncFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsSearchFallbackFactroy.class);

    @Override
    public NewsSyncFeignService create(Throwable throwable) {

        return new NewsSyncFeignService() {
            @Override
            public ResponseEntity generateRecommeded(List<NewsRecommended> newsRecommendedList) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:{}",newsRecommendedList);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity save(News news) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:{}",news);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity updateStatus(News news) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:{}",news);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}