package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.news.param.VideoBlackParam;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.param.VideoViewParam;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class PushMsgSupplyFallbackFactory implements FallbackFactory<PushMsgSupplyFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(PushMsgSupplyFallbackFactory.class);

    @Override
    public PushMsgSupplyFeignService create(Throwable throwable) {
        return new PushMsgSupplyFeignService() {

            @Override
            public void pushMsg(PushMessage message) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:{}",message);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushShareData(Long userId, Long newsId) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:userId:{},newsId:{}",userId,newsId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushViewData(Long userId, Long newsId) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:userId:{},newsId:{}",userId,newsId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushActiveViewData(Long userId, Long newsId) {
                //记录请求参数
                LOGGER.error("pushActiveViewData,参数:userId:{},newsId:{}",userId,newsId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushNewClickData(Long userId, Long newsId) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:userId:{},newsId:{}",userId,newsId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushCollectData(Long userId, Long newsId, Byte type) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:userId:{},newsId:{},type:{}",userId,newsId,type);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushCommentData(Long userId, Long newsId) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:userId:{},newsId:{}",userId,newsId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushVideoBlackData(VideoBlackParam videoBlackParam) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:{}",videoBlackParam);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushVideoShareData(VideoShareParam videoShareParam) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:{}",videoShareParam);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushVideoViewData(VideoViewParam videoViewParam) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:{}",videoViewParam);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushVideoCommentData(Long userId, Long newsId) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:userId:{},newsId:{}",userId,newsId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushPostRecommededData(Long userId, List<Long> postIds) {
                //记录请求参数
                LOGGER.error("pushPostRecommededData,参数:userId:{},postIds:{}",userId,postIds);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushPostActiveViewData(Long userId, Long postId) {
//记录请求参数
                LOGGER.error("pushPostActiveViewData,参数:userId:{},postIds:{}",userId,postId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushPostClickData(Long userId, Long postId) {
//记录请求参数
                LOGGER.error("pushPostClickData,参数:userId:{},postIds:{}",userId,postId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

        };
    }
}
