package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.UserAccountFeignService;
import com.bxm.localnews.param.AccountGoldParam;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class UserAccountFallbackFactory implements FallbackFactory<UserAccountFeignService> {

    @Override
    public UserAccountFeignService create(Throwable throwable) {
        return new UserAccountFeignService() {
            @Override
            public ResponseEntity<Boolean> addGold(AccountGoldParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Integer> getUsableGold(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(0);
            }

            @Override
            public ResponseEntity<Integer> countGoldByPostId(Long postId, Long userId) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}
