package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.dto.User;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.vo.VirtualUserInfo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Slf4j
public class UserFallbackFactory implements FallbackFactory<UserFeignService> {


    @Override
    public UserFeignService create(Throwable throwable) {
        return new UserFeignService() {

            @Override
            public ResponseEntity<UserBean> selectUserFromCache(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<Boolean> addPostReplyNum(Long userId, Integer type) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<List<VirtualUserInfo>> getVirtualUserList(Integer num) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}
