package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.VoteFeignService;
import com.bxm.localnews.news.dto.VoteDetailDTO;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class VoteFeignFallbackFactory implements FallbackFactory<VoteFeignService> {
    @Override
    public VoteFeignService create(Throwable throwable) {
        return param -> ResponseEntity.ok(VoteDetailDTO.builder().build());
    }
}
