package com.bxm.localnews.integration;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.facade.AppVersionFeignService;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 对提供的facade接口进行二次封装，主要用于对返回值进行适配处理和转换
 * @author liujia
 */
@Service
public class AppVersionIntegrationService {

    private final AppVersionFeignService appVersionFeignService;

    @Autowired
    public AppVersionIntegrationService(AppVersionFeignService appVersionFeignService) {
        this.appVersionFeignService = appVersionFeignService;
    }

    public Boolean getPublishState(BasicParam param) {
        return appVersionFeignService.getPublishState(param).getBody();
    }

    /**
     * 2.4.0版本开始可以对新闻、帖子中的视频进行分享，客户端无法拦截webview中的视频播放，所以需要将视频标签替换为图片
     * 并添加点击事件，用于触发内部协议。
     * 2.4.0版本之前不需要进行处理
     * @param param 基础参数
     * @return true表示需要进行处理
     */
    public boolean needProcessContentVideo(BasicParam param) {
        return (param.getPlatform() == 1 || param.getPlatform() == 2)
                && StringUtils.compareVersion(param.getCurVer(), "2.4.0") >= 0;
    }

    /**
     * 2.5.2 需要在内容中的视频标签里的onclick里增加一个poster的属性来表示封面图
     * 2.5.0版本及之前不需要进行处理
     * @param param 基础参数
     * @return true表示需要进行处理
     */
    public boolean needProcessContentVideoPoster(BasicParam param) {
        return (param.getPlatform() == 1 || param.getPlatform() == 2)
                && StringUtils.compareVersion(param.getCurVer(), "2.5.0") > 0;
    }

    /**
     * 是否需要屏蔽评论中的敏感词
     * @param param 基础参数
     * @return true表示需要进行处理
     */
    public boolean needValidSensitive(BasicParam param) {
        return (param.getPlatform() == 1 || param.getPlatform() == 2)
                && StringUtils.compareVersion(param.getCurVer(), "2.5.0") > 0;
    }
}
