package com.bxm.localnews.integration;

import com.bxm.localnews.facade.NewsSearchFeignService;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsVO;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class NewsSearchIntegrationService {

    @Autowired
    private NewsSearchFeignService newsSearchFeignService;

    public List<NewsVO> multipleGet(Long[] ids) {
        ResponseEntity<List<NewsVO>> result = newsSearchFeignService.multipleGet(ids);
        if (null == result) {
            return Lists.newArrayList();
        }
        return result.getBody();
    }

    public List<News> listRecommendedNews(Long[] ids) {
        if(ids.length == 0){
            return Lists.newArrayList();
        }

        ResponseEntity<List<News>> result = newsSearchFeignService.listRecommendedNews(ids);
        if (null == result) {
            return Lists.newArrayList();
        }
        return result.getBody();
    }

    public List<News> listTopNews(int size,String areaCode) {
        if(size == 0){
            return Lists.newArrayList();
        }
        ResponseEntity<List<News>> result = newsSearchFeignService.listTopNews(size,areaCode);
        if (null == result) {
            return Lists.newArrayList();
        }
        return result.getBody();
    }
}
