package com.bxm.localnews.integration;

import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.news.param.VideoBlackParam;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.param.VideoViewParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class NewsStatisticIntegrationService {

    @Autowired
    PushMsgSupplyFeignService pushMsgSupplyFeignService;

    @Async
    public void pushShareData(Long userId,Long newsId){
        pushMsgSupplyFeignService.pushShareData(userId,newsId);
    }

    @Async
    public void pushViewData(Long userId,Long newsId){
        pushMsgSupplyFeignService.pushViewData(userId,newsId);
    }

    @Async
    public void pushNewClickData(Long userId,Long newsId){
        pushMsgSupplyFeignService.pushNewClickData(userId,newsId);
    }

    @Async
    public void pushCollectData(Long userId,Long newsId,Byte type){
        pushMsgSupplyFeignService.pushCollectData(userId,newsId,type);
    }

    @Async
    public void pushCommentData(Long userId,Long newsId){
        pushMsgSupplyFeignService.pushCommentData(userId,newsId);
    }

    @Async
    public void pushVideoViewData(VideoViewParam videoViewParam){
        pushMsgSupplyFeignService.pushVideoViewData(videoViewParam);
    }

    @Async
    public void pushVideoBlackData(VideoBlackParam videoBlackParam){
        pushMsgSupplyFeignService.pushVideoBlackData(videoBlackParam);
    }

    @Async
    public void pushVideoShareData(VideoShareParam videoShareParam){
        pushMsgSupplyFeignService.pushVideoShareData(videoShareParam);
    }

    @Async
    public void pushVideoCommentData(Long userId,Long newsId){
        pushMsgSupplyFeignService.pushVideoCommentData(userId,newsId);
    }

}
