package com.bxm.localnews.integration;

import javax.annotation.Resource;

import com.bxm.localnews.facade.UserAccountFeignService;
import com.bxm.localnews.param.AccountGoldParam;

import org.springframework.stereotype.Service;

@Service
public class UserAccountIntegrationService {

    @Resource
    private UserAccountFeignService userAccountFeignService;

    public Boolean addGold(AccountGoldParam param) {
        return userAccountFeignService.addGold(param).getBody();
    }

    public Integer getUsableGold(Long userId) {
        return userAccountFeignService.getUsableGold(userId).getBody();
    }

    public Integer countGoldByPostId(Long postId, Long userId) {
        return userAccountFeignService.countGoldByPostId(postId, userId).getBody();
    }
}
