package com.bxm.localnews.integration;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserIntegrationService extends BaseService {

    @Autowired
    private UserFeignService userFeignService;

    public UserBean selectUserFromCache(Long userId) {
        ResponseEntity<UserBean> userBeanResponseEntity = this.userFeignService.selectUserFromCache(userId);
        if (null != userBeanResponseEntity && null != userBeanResponseEntity.getBody()) {
            logger.debug("调用localnews-user服务获取用户信息->userId:[{}],返回:[{}]",userId,JSONObject.toJSONString(userBeanResponseEntity.getBody()));
            return userBeanResponseEntity.getBody();
        }
        return null;
    }

    public Boolean addPostReplyNum(Long userId, Integer type) {
        return this.userFeignService.addPostReplyNum(userId, type).getBody();
    }

    public List<VirtualUserInfo> getVirtualUserList(Integer type) {
        return this.userFeignService.getVirtualUserList(type).getBody();
    }

}
