package com.bxm.localnews.integration;

import com.bxm.localnews.facade.VoteFeignService;
import com.bxm.localnews.news.dto.VoteDetailDTO;
import com.bxm.localnews.param.VotePinParam;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;

@Service
public class VoteIntegrationService {

    @Resource
    private VoteFeignService voteFeignService;

    public VoteDetailDTO get(@RequestParam VotePinParam param) {
        ResponseEntity<VoteDetailDTO> response = voteFeignService.get(param);
        VoteDetailDTO result = response.getBody();
        if (null == result || result.getVoteId() == null) {
            return null;
        }
        return result;
    }
}
