package com.bxm.localnews.param;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/14 20:57
 * @desc
 */
@ApiModel(description = "账户金币参数")
public class AccountGoldParam extends BaseBean implements IUserIdSharding {


    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "金币类型", required = true)
    private String goldType;

    @ApiModelProperty(value = "是否增加累计", required = true)
    private Boolean isAddTotal;

    @ApiModelProperty(value = "金币，可为负值", required = true)
    private Integer gold;

    @ApiModelProperty(value = "业务id", required = true)
    private Long relationId;

    @ApiModelProperty(value = "流水类型", required = true)
    private String goldFlowType;

    @ApiModelProperty(value = "显示内容", required = true)
    private String content;

    public AccountGoldParam() {
    }

    public AccountGoldParam(Long userId, String goldType, Boolean isAddTotal, Integer gold,
                            Long relationId, String goldFlowType, String content) {
        this.userId = userId;
        this.goldType = goldType;
        this.isAddTotal = isAddTotal;
        this.gold = gold;
        this.relationId = relationId;
        this.goldFlowType = goldFlowType;
        this.content = content;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getGoldType() {
        return goldType;
    }

    public void setGoldType(String goldType) {
        this.goldType = goldType;
    }

    public Boolean getAddTotal() {
        return isAddTotal;
    }

    public void setAddTotal(Boolean addTotal) {
        isAddTotal = addTotal;
    }

    public Integer getGold() {
        return gold;
    }

    public void setGold(Integer gold) {
        this.gold = gold;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public String getGoldFlowType() {
        return goldFlowType;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setGoldFlowType(String goldFlowType) {
        this.goldFlowType = goldFlowType;
    }

    public static AccountGoldParam buildPostLikeExpendParam(Long userId,int goldNum,Long id,String content){
        return new AccountGoldParam(userId, "CONSUME_GOLD", false, goldNum, id, "ARTICLE_LIKE_EXPEND",content);
    }

    public static AccountGoldParam buildPostLikeAddParam(Long userId,int goldNum,Long id,String content){
        return  new AccountGoldParam(userId, "USABLE_GOLD", true, goldNum, id, "ARTICLE_LIKE_ADD",content);
    }

    public static AccountGoldParam buildAddRecommandPoolParam(Long userId,int goldNum,Long id,String content){
        return  new AccountGoldParam(userId, "USABLE_GOLD", true, goldNum, id, "POST_ADD_POOL",content);
    }

}
