package com.bxm.localnews.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 *     论坛推荐参数
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/4
 */
@ApiModel(description = "论坛推荐参数")
public class ForumParam extends PageParam {
    @ApiModelProperty(value = "用户ID", required = true)
    private Long userId;
    @ApiModelProperty(value = "运营位id(1首页,2社区首页,3话题最新,4话题热门,5板块最新,6板块精华,7帖子详情,8新闻详情)", required = true)
    private Integer operationId;
    @ApiModelProperty(value = "区域编码", required = true)
    private String areaCode;
    @ApiModelProperty(value = "动作参数(2上划,1下拉)", required = true)
    private Integer actionType;
    @ApiModelProperty(value = "板块id(查询板块时必填)", required = false)
    private Long forumId;
    @ApiModelProperty(value = "话题id(查询话题时必填)", required = false)
    private Long topicId;
    @ApiModelProperty(value = "帖子ID(详情推荐必填)", required = false)
    private Long postId;
    @ApiModelProperty(value = "推荐新闻数量(详情推荐必填)", required = true)
    private Integer newsNum;
    @ApiModelProperty(value = "推荐帖子数量(详情推荐必填)", required = true)
    private Integer postNum;
    @ApiModelProperty(value = "平台编码", required = true)
    private Integer platform;

    public Integer getNewsNum() {
        return newsNum;
    }

    public void setNewsNum(Integer newsNum) {
        this.newsNum = newsNum;
    }

    public Integer getPostNum() {
        return postNum;
    }

    public void setPostNum(Integer postNum) {
        this.postNum = postNum;
    }

    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getOperationId() {
        return operationId;
    }

    public void setOperationId(Integer operationId) {
        this.operationId = operationId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Integer getActionType() {
        return actionType;
    }

    public void setActionType(Integer actionType) {
        this.actionType = actionType;
    }

    public Long getForumId() {
        return forumId;
    }

    public void setForumId(Long forumId) {
        this.forumId = forumId;
    }

    public Long getTopicId() {
        return topicId;
    }

    public void setTopicId(Long topicId) {
        this.topicId = topicId;
    }

    public Integer getPlatform() {
        return platform;
    }

    public void setPlatform(Integer platform) {
        this.platform = platform;
    }
}
