package com.bxm.localnews.news.manage.controller.forum;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.param.AdminForumParam;
import com.bxm.localnews.news.model.param.AdminForumUpdateParam;
import com.bxm.localnews.news.model.vo.AdminForum;
import com.bxm.localnews.news.service.AdminForumService;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "1-40 [管理]版块管理", description = "版块管理")
@RestController
@RequestMapping("api/admin/forum")
public class AdminForumController extends BaseController {

    @Resource
    private AdminForumService adminForumService;

    @ApiOperation(value = "1-40-1 获取版块列表")
    @GetMapping("list")
    public Json<PageWarper<AdminForum>> getList(AdminForumParam param) {
        return ResultUtil.genSuccessResult(adminForumService.getList(param));
    }

    @ApiOperation(value = "1-40-2 获取版块详情")
    @GetMapping("detail")
    public Json<AdminForum> getForumById(Long id) {
        return ResultUtil.genSuccessResult(adminForumService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-40-3 版块上下架")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态：0下架 1上架", required = true)
    })
    @PostMapping("updateStatus")
    public Json updateStatusById(Long id, Byte status) {
        return ResultUtil.genSuccessResult(adminForumService.updateStatus(id, status));
    }

    @ApiOperation(value = "1-40-4 新增或编辑版块")
    @PostMapping("saveOrUpdate")
    public Json saveOrUpdate(@RequestBody AdminForum adminForum) {
        return ResultUtil.genSuccessResult(adminForumService.saveOrUpdate(adminForum));
    }

    @ApiOperation(value = "1-40-5 修改版块权重")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "order", value = "权重", required = true)
    })
    @PostMapping("updateOrder")
    public Json updateOrderById(Long id, Integer order) {
        return ResultUtil.genSuccessResult(adminForumService.updateOrder(id, order));
    }

    @ApiOperation(value = "1-40-6 获取简单版块列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "key", value = "关键字")
    })
    @GetMapping("getSimpleList")
    public Json<List<AdminForum>> getSimpleList(String key) {
        return ResultUtil.genSuccessResult(adminForumService.getSimpleList(key));
    }

    @ApiOperation(value = "1-40-7 编辑帖子中的板块")
    @PostMapping("/post/update")
    public Json updateTopicOrForum(@RequestBody AdminForumUpdateParam adminForumUpdateParam) {
        adminForumService.updatePostForum(adminForumUpdateParam);
        return ResultUtil.genSuccessResult();
    }

}

