package com.bxm.localnews.news.manage.controller.forum;

import com.bxm.component.office.excel.export.impl.SimpleExcelExporter;
import com.bxm.component.office.excel.export.setting.ExcelSheet;
import com.bxm.component.office.excel.export.setting.ExportSetting;
import com.bxm.component.office.excel.export.setting.SheetHeader;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.dto.AdminGetPostUrlDTO;
import com.bxm.localnews.news.model.param.AdminForumPostParam;
import com.bxm.localnews.news.model.vo.AdminBaseForumPost;
import com.bxm.localnews.news.model.vo.AdminBaseForumPostExcelVO;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminForumPostApproveHistory;
import com.bxm.localnews.news.service.AdminForumPostService;
import com.bxm.localnews.news.util.SecurityUtils;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.*;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import static com.bxm.newidea.component.tools.DateUtils.DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL;

@Api(tags = "1-42 [管理]帖子管理", description = "帖子管理")
@RestController
@RequestMapping("api/admin/forumPost")
public class AdminForumPostController extends BaseController {

    @Resource
    private AdminForumPostService adminForumPostService;

    @ApiOperation(value = "1-42-1 获取帖子审核列表")
    @GetMapping("/listApprove")
    public Json<PageWarper<AdminBaseForumPost>> getApprovePostList(AdminForumPostParam param) {
        return ResultUtil.genSuccessResult(adminForumPostService.getApproveList(param));
    }

    @ApiOperation(value = "1-42-2 获取帖子详情")
    @GetMapping("/detail")
    public Json<AdminForumPost> getForumPostById(Long id) {
        return ResultUtil.genSuccessResult(adminForumPostService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-42-3 批量帖子审核")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "帖子id列表，逗号分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态 " +
                    "1:[审核通过]设置正常显示 " +
                    "3:审核拒绝 " +
                    "4:删除帖子 " +
                    "5:[审核通过]设置仅楼主可见 " +
                    "6:[审核通过]设置本地圈屏蔽", required = true),
            @ApiImplicitParam(name = "comment", value = "审核意见", required = false)
    })
    @PostMapping("approve")
    public Json approve(String ids, Byte status, String comment) {
        return ResultUtil.genSuccessResult(adminForumPostService.approve(ids,
                status,
                comment,
                SecurityUtils.getAdminUserId()));
    }

    @ApiOperation(value = "1-42-4 新增或编辑帖子")
    @PostMapping("saveOrUpdate")
    public Json saveOrUpdate(@RequestBody AdminForumPost adminForumPost) {
        Message message = adminForumPostService.saveOrUpdate(adminForumPost, SecurityUtils.getAdminUserId());
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "1-42-5 批量删除或恢复帖子")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "帖子id列表，逗号分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态：1正常 4删除", required = true),
            @ApiImplicitParam(name = "deductGold", value = "是否扣金币：0不扣 1扣", required = false)
    })
    @PostMapping("deleteOrRecover")
    public Json deleteOrRecover(String ids, Byte status, Byte deductGold) {
        return ResultUtil.genSuccessResult(adminForumPostService.deleteOrRecover(ids, status, deductGold));
    }

    @ApiOperation(value = "1-42-6 获取新增帖子id")
    @GetMapping("/getCreateId")
    public Json<Long> getCreateId() {
        return ResultUtil.genSuccessResult(adminForumPostService.getCreateId());
    }

    @ApiOperation(value = "1-42-7 获取帖子审核历史列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
            @ApiImplicitParam(name = "action", value = "审批动作：0拒绝，1通过", required = false)
    })
    @GetMapping("/listApproveHistory")
    public Json<List<AdminForumPostApproveHistory>> getApproveHistoryList(Long id, Integer action) {
        return ResultUtil.genSuccessResult(adminForumPostService.getApproveHistoryList(id, action));
    }

    @ApiOperation(value = "1-42-8 将帖子内容生成一条待审核状态的本地新闻，插入本地新闻库", notes = "帖子若处于待发布，则新闻也处于待发布")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
    })
    @PostMapping("/transformPost2News")
    public Json transformPost2News(Long id) {
        return adminForumPostService.transformPost2News(id);
    }


    @ApiOperation(value = "1-42-9 增加帖子马甲号点赞", notes = "帖子马甲号点赞")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postId", value = "帖子id", required = true),
            @ApiImplicitParam(name = "startTime", value = "开始时间", required = true),
            @ApiImplicitParam(name = "endTime", value = "结束时间", required = true),
            @ApiImplicitParam(name = "num", value = "增加数量", required = true),
    })
    @PostMapping("/addPostLike")
    public Json addPostLike(@RequestParam(value = "postId") Long postId,
                            @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT) Date startTime,
                            @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT) Date endTime,
                            @RequestParam Integer num) {
        adminForumPostService.doAddPostLike(postId, startTime, endTime, num);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "1-42-10 excel批量导入小纸条", notes = "格式：用户id，小纸条文本，定时发布时间，有效期，地区编码")
    @PostMapping(value = "/importNotes")
    public Json importNotes(@RequestParam(value = "files") MultipartFile... multipartFiles) {
        adminForumPostService.importNotes(SecurityUtils.getAdminUserId(), multipartFiles);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "1-42-10 判断帖子列表中是否存在现金奖励贴")
    @ApiImplicitParam(name = "ids", value = "帖子ID列表")
    @GetMapping("hasCashPost")
    public ResponseJson<Boolean> hasCashPost(String ids) {
        return ResponseJson.ok(adminForumPostService.hasCashPost(ids));
    }


    @ApiOperation(value = "1-42-12 获取链接")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id",required = true),
            @ApiImplicitParam(name = "areaCode", value = "区域编码",required = true),
            @ApiImplicitParam(name = "id", value = "帖子id",required = true),
            @ApiImplicitParam(name = "cityName", value = "区域名称",required = true),
            @ApiImplicitParam(name = "type", value = "0-短链 1-长链接 2-站内链接",required = true),
            @ApiImplicitParam(name = "channel", value = "预留字段-渠道名称，现在默认是wx"),
    })
    @GetMapping("getPostUrl")
    public ResponseJson<String> getPostUrl(@ApiIgnore AdminGetPostUrlDTO adminGetPostUrlDTO) {
        return ResponseJson.ok(adminForumPostService.getPostUrl(adminGetPostUrlDTO));
    }

    @ApiOperation(value = "1-42-13 获取帖子列表文件（此方法将返回文件流）")
    @GetMapping("listApprove/excel")
    public ResponseJson getApprovePostListExcel(AdminForumPostParam param, HttpServletResponse response) throws IOException {
        Date maxBefore = DateUtils.addField(new Date(), Calendar.DAY_OF_MONTH, -30);
        if (Objects.isNull(param.getPublishStartTime())) {
            // 设置30天之前
            param.setPublishStartTime(maxBefore);
        } else {
            if (param.getPublishStartTime().before(maxBefore)) {
                return ResponseJson.badReqeuset("不允许下载30天之前的帖子").build();
            }
        }

        // 查询数据
        param.setPageNum(null);
        param.setPageSize(null);
        List<AdminBaseForumPostExcelVO> approveList = adminForumPostService.getApproveListExcelVO(param);

        SimpleExcelExporter excelExporter = SpringContextHolder.getBean(SimpleExcelExporter.class);

        ExportSetting setting = new ExportSetting();
        ExcelSheet excelSheet = setting.addSheet();
        excelSheet.setDataCollection(approveList);
        excelSheet.setFreezeHeader(true);
        excelSheet.setSheetName("帖子列表");
        excelSheet.setDefaultWidth(30);

        excelSheet.addHeader(new SheetHeader(("帖子id"), "id"));
        excelSheet.addHeader(new SheetHeader(("帖子标题"), "title"));
        excelSheet.addHeader(new SheetHeader(("发帖地址"), "location"));
        excelSheet.addHeader(new SheetHeader(("发帖区域编码"), "areaCode"));
        excelSheet.addHeader(new SheetHeader(("帖子文本"), "textField"));
        excelSheet.addHeader(new SheetHeader(("作者id"), "userId"));
        excelSheet.addHeader(new SheetHeader(("作者名称"), "userName"));
        excelSheet.addHeader(new SheetHeader(("是否精华帖"), "isBrilliant"));
        excelSheet.addHeader(new SheetHeader(("是否推荐（是否优质头条）"), "isRecommend"));
        excelSheet.addHeader(new SheetHeader(("是否红色章"), "isRed"));
        excelSheet.addHeader(new SheetHeader(("是否奖励现金"), "isCash"));
        excelSheet.addHeader(new SheetHeader(("现金奖励金额"), "cashReward"));
        excelSheet.addHeader(new SheetHeader(("是否本地爆料"), "isBroke"));
        excelSheet.addHeader(new SheetHeader(("创建时间"), "createTime"));
        excelSheet.addHeader(new SheetHeader(("定时发布时间"), "publishTime"));
        excelSheet.addHeader(new SheetHeader(("展示时间"), "displayTime"));
        excelSheet.addHeader(new SheetHeader(("帖子状态"), "status"));
        excelSheet.addHeader(new SheetHeader(("发布区域类型"), "deliveryType"));
        excelSheet.addHeader(new SheetHeader(("帖子类型"), "postType"));
        excelSheet.addHeader(new SheetHeader(("有效期"), "validDay"));
        excelSheet.addHeader(new SheetHeader(("到期时间"), "validDate"));
        excelSheet.addHeader(new SheetHeader(("发帖区域"), "areaDetail"));
        excelSheet.addHeader(new SheetHeader(("话题id列表"), "topicIdList"));
        excelSheet.addHeader(new SheetHeader(("更新时间"), "modifyTime"));
        excelSheet.addHeader(new SheetHeader(("发帖人身份"), "identity"));
        excelSheet.addHeader(new SheetHeader(("是否过期"), "isValid"));

        processDownload(DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL.get().format(new Date()) + "帖子批量导出.xls", response);
        excelExporter.export(response.getOutputStream(), setting);

        return ResponseJson.build();
    }

}

