package com.bxm.localnews.news.manage.controller.news;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.service.AdminNewsBlackService;
import com.bxm.localnews.news.service.AdminVideoService;
import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "1-22 新闻（视频）黑名单管理", description = "新闻（视频）黑名单管理的相关操作")
@RestController
@RequestMapping("api/admin")
public class AdminBlackListController extends BaseController {

    private AdminNewsBlackService adminNewsBlackService;

    private AdminVideoService adminVideoService;

    @Autowired
    public AdminBlackListController(AdminNewsBlackService adminNewsBlackService, AdminVideoService adminVideoService) {
        this.adminNewsBlackService = adminNewsBlackService;
        this.adminVideoService = adminVideoService;
    }

    @PostMapping(value = "/black/news/add")
    @ApiOperation(value = "1-22-03  新增新闻黑名单", notes = "新增新闻黑名单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "新闻id", required = true),
            @ApiImplicitParam(name = "remark", value = "备注")
    })
    public Json addNewsBlack(Long id, String remark) {
        adminNewsBlackService.addNewsBlack(id, remark);
        return ResultUtil.genSuccessResult();
    }

    @PostMapping(value = "/black/news/delete")
    @ApiOperation(value = "1-22-07  新增新闻黑名单", notes = "删除新闻黑名单(新闻上架)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "新闻id", required = true),
    })
    public Json delNewsBlack(Long id) {
        adminNewsBlackService.delNewsBlack(id);
        return ResultUtil.genSuccessResult();
    }

    @PostMapping(value = "/black/video/add")
    @ApiOperation(value = "1-22-06 新增视频黑名单", notes = "新增视频黑名单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "新闻id", required = true),
            @ApiImplicitParam(name = "remark", value = "备注")
    })
    public Json addVideoBlack(Long id, String remark) {
        adminVideoService.addVideoBlack(id, remark);
        return ResultUtil.genSuccessResult();
    }
}
