package com.bxm.localnews.news.manage.controller.news;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.param.AdminMarketingActivitiesInfoParam;
import com.bxm.localnews.news.model.param.AdminMarketingActivitiesPageQueryParam;
import com.bxm.localnews.news.model.vo.AdminMarketingActivities;
import com.bxm.localnews.news.service.AdminMarketingActivitiesService;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;


@Api(tags = "1-24 [管理]营销活动管理", description = "营销活动相关信息管理")
@RestController
@RequestMapping("api/admin/marketingActivities")
public class AdminMarketingActivitiesController extends BaseController {

    @Autowired
    private AdminMarketingActivitiesService adminMarketingActivitiesService;

    @ApiOperation(value = "1-24-1 新增营销活动")
    @PostMapping("/add")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "title", value = "标题", required = true),
            @ApiImplicitParam(name = "author", value = "作者", required = true),
            @ApiImplicitParam(name = "source", value = "来源", required = true),
            @ApiImplicitParam(name = "showTime", value = "展示时间", required = true),
            @ApiImplicitParam(name = "publishTime", value = "发布时间", required = true),
            @ApiImplicitParam(name = "showLevels", value = "(逗号间隔)热门标签 0：置顶 1：热 3：活动 4：本地 99：普通信息流", required = true),
            @ApiImplicitParam(name = "deliveryType", value = "投放区域类型0：全国 1：地方区域", required = true),
            @ApiImplicitParam(name = "linkUrl", value = "外链地址", required = true),
            @ApiImplicitParam(name = "areaCodes", value = "(逗号间隔)地方区域编码"),
            @ApiImplicitParam(name = "coverUrls", value = "(逗号间隔)封面图")
    })
    public Json add(@RequestParam("title") String title, @RequestParam("author") String author,
                    @RequestParam("source") String source, @RequestParam("showTime") Date showTime,
                    @RequestParam("publishTime") Date publishTime, @RequestParam("showLevels") String showLevels,
                    @RequestParam("deliveryType") Integer deliveryType, @RequestParam("linkUrl") String linkUrl,
                    @RequestParam(value = "areaCodes", required = false) String areaCodes, @RequestParam(value = "coverUrls", required = false) String coverUrls) {
        return adminMarketingActivitiesService.addMarketingActivities(title, author, source, showTime, publishTime, StringUtils.isBlank(showLevels) ? null : showLevels.split(","),
                deliveryType, linkUrl, StringUtils.isBlank(areaCodes) ? null : areaCodes.split(","), StringUtils.isBlank(coverUrls) ? null : coverUrls.split(","));
    }

    @ApiOperation(value = "1-24-2 修改营销活动")
    @PostMapping("/update")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true),
            @ApiImplicitParam(name = "title", value = "标题", required = true),
            @ApiImplicitParam(name = "author", value = "作者", required = true),
            @ApiImplicitParam(name = "source", value = "来源", required = true),
            @ApiImplicitParam(name = "showTime", value = "展示时间", required = true),
            @ApiImplicitParam(name = "publishTime", value = "发布时间", required = true),
            @ApiImplicitParam(name = "showLevels", value = "(数组)热门标签 0：置顶 1：热 3：活动 4：本地 99：普通信息流"),
            @ApiImplicitParam(name = "linkUrl", value = "外链地址", required = true),
            @ApiImplicitParam(name = "coverUrls", value = "(数组)封面图")
    })
    public Json update(@RequestParam("id") Long id, @RequestParam("title") String title, @RequestParam("author") String author,
                       @RequestParam("source") String source, @RequestParam("showTime") Date showTime,
                       @RequestParam("publishTime") Date publishTime, @RequestParam(value = "showLevels", required = false) String showLevels,
                       @RequestParam("linkUrl") String linkUrl, @RequestParam(value = "coverUrls", required = false) String coverUrls,
                       @RequestParam("deliveryType") Integer deliveryType, @RequestParam(value = "areaCodes", required = false) String areaCodes) {
        return adminMarketingActivitiesService.updateMarketingActivities(id, title, author, source, showTime, publishTime,
                StringUtils.isBlank(showLevels) ? null : showLevels.split(","), linkUrl,
                StringUtils.isBlank(coverUrls) ? null : coverUrls.split(","), deliveryType, areaCodes);
    }

    @ApiOperation(value = "1-24-3 上线")
    @GetMapping("/enable/{id}")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true),
    })
    public Json enable(@PathVariable("id") Long id) {
        return adminMarketingActivitiesService.enableMarketingActivities(id);
    }

    @ApiOperation(value = "1-24-4 下线")
    @GetMapping("/disable/{id}")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true),
    })
    public Json disable(@PathVariable("id") Long id) {
        return adminMarketingActivitiesService.disableMarketingActivities(id);
    }


    @ApiOperation(value = "1-24-5 分页列表查询")
    @PostMapping("/list")
    public Json<PageWarper<AdminMarketingActivities>> list(AdminMarketingActivitiesPageQueryParam param) {
        PageWarper<AdminMarketingActivities> pageWarper = adminMarketingActivitiesService.listForManage(param);
        return ResultUtil.genSuccessResult(pageWarper);
    }

    @ApiOperation(value = "1-24-6 获取详情")
    @GetMapping("/get/{id}")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true),
    })
    public Json<AdminMarketingActivitiesInfoParam> get(@PathVariable("id") Long id) {
        return adminMarketingActivitiesService.findById(id);
    }
}
