package com.bxm.localnews.news.manage.controller.news;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.param.AdminNewsKindParam;
import com.bxm.localnews.news.model.vo.AdminNewsKind;
import com.bxm.localnews.news.service.AdminNewsKindService;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/2/15 14:06
 * @desc
 */
@Api(tags = "1-30 [管理]新闻频道管理", description = "新闻频道管理的相关操作")
@RestController
@RequestMapping("api/admin/kind")
public class AdminNewsKindController {

    @Autowired
    private AdminNewsKindService adminNewsKindService;

    @ApiOperation(value = "1-30-1 获取新闻频道列表", notes = "根据输入参数获取对应的新闻频道数据")
    @GetMapping("/list")
    public Json<PageWarper<AdminNewsKind>> getNewsKindList(AdminNewsKindParam adminNewsKindParam) {
        return ResultUtil.genSuccessResult(this.adminNewsKindService.queryNewsKinds(adminNewsKindParam));
    }

    @ApiOperation(value = "1-30-2 获取新闻频道详情", notes = "")
    @GetMapping("/detail")
    public Json<AdminNewsKind> getNewsKindById(Long id) {
        return ResultUtil.genSuccessResult(this.adminNewsKindService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-30-3 新闻频道上下架", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("updateStatus")
    public Json updateNewsKindStatusById(Long id, Byte status) {
        if (this.adminNewsKindService.updateNewsKindStatus(id, status) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-30-4 新增或编辑新闻频道", notes = "")
    @PostMapping("saveOrUpdateKinds")
    public Json addNewsKindDetail(AdminNewsKind adminNewsKind) {
        if (this.adminNewsKindService.addNewsKind(adminNewsKind) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }
}
