package com.bxm.localnews.news.manage.controller.news;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.param.AdminNewsInformParam;
import com.bxm.localnews.news.model.vo.AdminNewsInform;
import com.bxm.localnews.news.service.AdminNewsInformService;
import com.bxm.localnews.news.util.SecurityUtils;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@Api(tags = "1-08 [管理]新闻举报接口管理", description = "新闻举报相关操作")
@RestController
@RequestMapping("api/admin/report")
public class AdminNewsReportController extends BaseController {

    @Autowired
    private AdminNewsInformService adminNewsInformService;

    @ApiOperation(value = "1-8-1 获取用户举报列表", notes = "")
    @RequestMapping(value = "list", method = RequestMethod.GET)
    public Json<PageWarper<AdminNewsInform>> getReplys(AdminNewsInformParam adminNewsInformParam) {

        return ResultUtil.genSuccessResult(this.adminNewsInformService.queryNewsInforms(adminNewsInformParam));

    }

    @ApiOperation(value = "1-8-2 更新举报信息", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "信息id", required = true),
            @ApiImplicitParam(name = "result", value = "结果", required = true),
            @ApiImplicitParam(name = "reply", value = "回复", required = true)
    })
    @RequestMapping(value = "updateReport", method = RequestMethod.GET)
    public Json updateReport(@RequestParam(value = "id", required = true) String id,
                             @RequestParam(value = "result", required = true) String result,
                             @RequestParam(value = "reply", required = true) String reply
    ) {
        if (StringUtils.isEmpty(String.valueOf(id))) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "参数错误");
        }
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        map.put("operator", SecurityUtils.getAdminUserId());
        map.put("result", result);
        map.put("reply", reply);

        int flag = this.adminNewsInformService.updateByMap(map);

        if (flag > 0) {
            return ResultUtil.genSuccessMsg("操作成功");
        } else {

            return ResultUtil.genFailedResult("操作失败");
        }
    }

}
