package com.bxm.localnews.news.manage.controller.news;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.param.AdminNewsDetailStatisticsParam;
import com.bxm.localnews.news.model.param.AdminNewsSourceStatisticsParam;
import com.bxm.localnews.news.model.vo.AdminNewsSourceInfoBean;
import com.bxm.localnews.news.service.AdminNewsSourceStatisticsService;
import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "1-29 新闻来源统计", description = "根据新闻来源进行统计")
@RestController
@RequestMapping("api/admin/news/statistics")
public class AdminNewsSourceStatisticsController extends BaseController {

    @Autowired
    private AdminNewsSourceStatisticsService adminNewsSourceStatisticsService;

    @ApiOperation(value = "1-29-1 新闻区域统计", notes = "用于统计不同区域的新闻数量")
    @GetMapping("list")
    public Json<List<AdminNewsSourceInfoBean>> list(AdminNewsSourceStatisticsParam param) {
        return ResultUtil.genSuccessResult(adminNewsSourceStatisticsService.query(param));
    }

    @ApiOperation(value = "1-29-2 新闻来源统计", notes = "用于统计区域下的新闻数量")
    @GetMapping("detail")
    public Json<List<AdminNewsSourceInfoBean>> detailList(AdminNewsDetailStatisticsParam param) {
        return ResultUtil.genSuccessResult(adminNewsSourceStatisticsService.queryDetail(param));
    }
}
