package com.bxm.localnews.news.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

@Data
@Builder
@ApiModel(description = "待爬取公众号查询结果")
public class AdminAccountQueryDto {
    @Tolerate
    public AdminAccountQueryDto() {
    }

    @ApiModelProperty(name = "主键id")
    private Long id;

    @ApiModelProperty(name = "公众号名称")
    private String name;

    @ApiModelProperty(name = "微信公众号")
    private String account;

    @ApiModelProperty(name = "新闻分类")
    private String channel;

    @ApiModelProperty(name = "区域编码")
    private String regionCode;

    @ApiModelProperty(name = "区域名称")
    private String regionName;
}
