package com.bxm.localnews.news.model.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class AdminMixRecommandDTO {

    @ApiModelProperty("新闻或帖子id")
    private Long id;

    @ApiModelProperty("新闻或帖子标题")
    private String title;

    @ApiModelProperty("新闻或帖子投放地区")
    private String areaDetail;

    @ApiModelProperty("权重")
    private Integer weight;

    @ApiModelProperty("来源 1：社区帖子 2：本地新闻 3：全国新闻")
    private String origin;

    @ApiModelProperty("添加时间")
    private Date addTime;

    @ApiModelProperty("发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date issueTime;

    @ApiModelProperty("状态 0：下线 1：上线   ")
    private Byte status;

    @ApiModelProperty("推荐时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date recommendTime;

    @ApiModelProperty("作者")
    private String author;

    @ApiModelProperty("详情链接")
    private String linkUrl;

    @ApiModelProperty("发布人id")
    private Long userId;

    @ApiModelProperty("发布区域类型0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("是否是未到推荐时间的预推荐帖子 1: 是")
    private Integer isPreRecommend;

    @ApiModelProperty("3.11.0 帖子类型")
    private String postType;
}
