package com.bxm.localnews.news.model.entity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author gonzo
 * @date 2021-03-03 15:41
 **/
public class ForumPostSnapshot {
    /**
     * 主键
     */
    private Long id;

    /**
     * 帖子id
     */
    private Long postId;

    /**
     * 帖子内容（最终显示文本，HTML）
     */
    private String content;

    /**
     * 帖子文本部分
     */
    private String textField;

    /**
     * 帖子图片（json字符串）
     */
    private String imgList;

    /**
     * 帖子标题
     */
    private String title;

    /**
     * 发帖时的用户位置（默认取所属区域名称）
     */
    private String location;

    /**
     * 发帖用户所属区域
     */
    private String areaCode;

    /**
     * 发帖用户ID
     */
    private Long userId;

    /**
     * 发帖用户头像
     */
    private String userImg;

    /**
     * 发帖用户名称
     */
    private String userName;

    /**
     * 是否精华帖(显示精华帖的章)
     */
    private Byte isBrilliant;

    /**
     * 是否推荐
     */
    private Byte isRecommend;

    /**
     * 是否红色章（只对精华帖有效）
     */
    private Byte isRed;

    /**
     * 是否发放了现金奖励
     */
    private Byte isCash;

    /**
     * 现金奖励金额
     */
    private BigDecimal cashReward;

    /**
     * 创建人（仅针对运营录入）
     */
    private Long creator;

    /**
     * 展示标签：1热 2爆
     */
    private Byte displayTag;

    /**
     * 自定义标签内容
     */
    private String labelDiv;

    /**
     * 发布时间（用于运营定时发布）
     */
    private Date publishTime;

    /**
     * 发布时间（用于客户端显示）
     */
    private Date displayTime;

    /**
     * 帖子状态(1:正常显示 2:审核中 3:审核拒绝 4:用户删除 5:仅楼主可见 6:本地圈屏蔽 7:运营删除)
     */
    private Byte status;

    /**
     * 阅读(点击)总数-用户真实看到的数量
     */
    private Integer clickCount;

    /**
     * 该帖子最终需要达到的用户阅读数量（由真实阅读数量计算而来）
     */
    private Long finalClickCount;

    /**
     * 有效阅读总数（3.8.0定义为真实阅读数量）
     */
    private Long reviewCount;

    /**
     * 初始基数
     */
    private Integer initialBasicNum;

    /**
     * 收藏总数
     */
    private Long collectCount;

    /**
     * 分享总数
     */
    private Long shareCount;

    /**
     * 评论总数
     */
    private Long commentCount;

    /**
     * 推荐总次数
     */
    private Long recommendCount;

    /**
     * 点赞总数
     */
    private Long likeCount;

    /**
     * 是否强引导下载  0:否 1:是
     */
    private Byte isBootDownload;

    /**
     * 编辑寄语id
     */
    private Long editorMessageId;

    /**
     * 评论概览信息
     */
    private String replyInfo;

    /**
     * 编辑寄语
     */
    private String editorMessage;

    /**
     * 点赞概览信息
     */
    private String likeInfo;

    /**
     * 封面图片列表
     */
    private String coverList;

    /**
     * 是否启用占位符
     */
    private Byte enablePlaceholder;

    /**
     * 是否本地爆料
     */
    private Byte isBroke;

    /**
     * 用户是否首次发帖 0：否 1：是
     */
    private Byte isFirstUserPost;

    /**
     * 封面选择 0:只取图片 1:只取第一个视频  2:取内容详情的视频和图片
     */
    private Byte coverSelect;

    /**
     * 版块内容
     */
    private String forumContent;

    private String plugins;

    /**
     * 是否用户修改,0否,1是
     */
    private Byte isUserUpdate;

    /**
     * 发布区域类型 0:全国 1:区域
     */
    private Byte deliveryType;

    /**
     * 帖子类型(1:普通帖子 2:小纸条)
     */
    private Byte postType;

    /**
     * 有效期(单位:天)
     */
    private Integer validDay;

    /**
     * 到期时间
     */
    private Date validDate;

    /**
     * 是否是活动帖子0否，1是
     */
    private Byte isActivityPost;

    /**
     * 是否分享奖励现金,0否，1是
     */
    private Byte isShareCash;

    /**
     * 选择的话题列表ID
     */
    private String topicIds;

    /**
     * 帖子热度值
     */
    private Integer hotScore;

    /**
     * 操作人id
     */
    private Long operator;

    /**
     * 创建时间（快照创建时间）
     */
    private Date createTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTextField() {
        return textField;
    }

    public void setTextField(String textField) {
        this.textField = textField;
    }

    public String getImgList() {
        return imgList;
    }

    public void setImgList(String imgList) {
        this.imgList = imgList;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserImg() {
        return userImg;
    }

    public void setUserImg(String userImg) {
        this.userImg = userImg;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Byte getIsBrilliant() {
        return isBrilliant;
    }

    public void setIsBrilliant(Byte isBrilliant) {
        this.isBrilliant = isBrilliant;
    }

    public Byte getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Byte isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Byte getIsRed() {
        return isRed;
    }

    public void setIsRed(Byte isRed) {
        this.isRed = isRed;
    }

    public Byte getIsCash() {
        return isCash;
    }

    public void setIsCash(Byte isCash) {
        this.isCash = isCash;
    }

    public BigDecimal getCashReward() {
        return cashReward;
    }

    public void setCashReward(BigDecimal cashReward) {
        this.cashReward = cashReward;
    }

    public Long getCreator() {
        return creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public Byte getDisplayTag() {
        return displayTag;
    }

    public void setDisplayTag(Byte displayTag) {
        this.displayTag = displayTag;
    }

    public String getLabelDiv() {
        return labelDiv;
    }

    public void setLabelDiv(String labelDiv) {
        this.labelDiv = labelDiv;
    }

    public Date getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public Date getDisplayTime() {
        return displayTime;
    }

    public void setDisplayTime(Date displayTime) {
        this.displayTime = displayTime;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Integer getClickCount() {
        return clickCount;
    }

    public void setClickCount(Integer clickCount) {
        this.clickCount = clickCount;
    }

    public Long getFinalClickCount() {
        return finalClickCount;
    }

    public void setFinalClickCount(Long finalClickCount) {
        this.finalClickCount = finalClickCount;
    }

    public Long getReviewCount() {
        return reviewCount;
    }

    public void setReviewCount(Long reviewCount) {
        this.reviewCount = reviewCount;
    }

    public Integer getInitialBasicNum() {
        return initialBasicNum;
    }

    public void setInitialBasicNum(Integer initialBasicNum) {
        this.initialBasicNum = initialBasicNum;
    }

    public Long getCollectCount() {
        return collectCount;
    }

    public void setCollectCount(Long collectCount) {
        this.collectCount = collectCount;
    }

    public Long getShareCount() {
        return shareCount;
    }

    public void setShareCount(Long shareCount) {
        this.shareCount = shareCount;
    }

    public Long getCommentCount() {
        return commentCount;
    }

    public void setCommentCount(Long commentCount) {
        this.commentCount = commentCount;
    }

    public Long getRecommendCount() {
        return recommendCount;
    }

    public void setRecommendCount(Long recommendCount) {
        this.recommendCount = recommendCount;
    }

    public Long getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(Long likeCount) {
        this.likeCount = likeCount;
    }

    public Byte getIsBootDownload() {
        return isBootDownload;
    }

    public void setIsBootDownload(Byte isBootDownload) {
        this.isBootDownload = isBootDownload;
    }

    public Long getEditorMessageId() {
        return editorMessageId;
    }

    public void setEditorMessageId(Long editorMessageId) {
        this.editorMessageId = editorMessageId;
    }

    public String getReplyInfo() {
        return replyInfo;
    }

    public void setReplyInfo(String replyInfo) {
        this.replyInfo = replyInfo;
    }

    public String getEditorMessage() {
        return editorMessage;
    }

    public void setEditorMessage(String editorMessage) {
        this.editorMessage = editorMessage;
    }

    public String getLikeInfo() {
        return likeInfo;
    }

    public void setLikeInfo(String likeInfo) {
        this.likeInfo = likeInfo;
    }

    public String getCoverList() {
        return coverList;
    }

    public void setCoverList(String coverList) {
        this.coverList = coverList;
    }

    public Byte getEnablePlaceholder() {
        return enablePlaceholder;
    }

    public void setEnablePlaceholder(Byte enablePlaceholder) {
        this.enablePlaceholder = enablePlaceholder;
    }

    public Byte getIsBroke() {
        return isBroke;
    }

    public void setIsBroke(Byte isBroke) {
        this.isBroke = isBroke;
    }

    public Byte getIsFirstUserPost() {
        return isFirstUserPost;
    }

    public void setIsFirstUserPost(Byte isFirstUserPost) {
        this.isFirstUserPost = isFirstUserPost;
    }

    public Byte getCoverSelect() {
        return coverSelect;
    }

    public void setCoverSelect(Byte coverSelect) {
        this.coverSelect = coverSelect;
    }

    public String getForumContent() {
        return forumContent;
    }

    public void setForumContent(String forumContent) {
        this.forumContent = forumContent;
    }

    public String getPlugins() {
        return plugins;
    }

    public void setPlugins(String plugins) {
        this.plugins = plugins;
    }

    public Byte getIsUserUpdate() {
        return isUserUpdate;
    }

    public void setIsUserUpdate(Byte isUserUpdate) {
        this.isUserUpdate = isUserUpdate;
    }

    public Byte getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Byte deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Byte getPostType() {
        return postType;
    }

    public void setPostType(Byte postType) {
        this.postType = postType;
    }

    public Integer getValidDay() {
        return validDay;
    }

    public void setValidDay(Integer validDay) {
        this.validDay = validDay;
    }

    public Date getValidDate() {
        return validDate;
    }

    public void setValidDate(Date validDate) {
        this.validDate = validDate;
    }

    public Byte getIsActivityPost() {
        return isActivityPost;
    }

    public void setIsActivityPost(Byte isActivityPost) {
        this.isActivityPost = isActivityPost;
    }

    public Byte getIsShareCash() {
        return isShareCash;
    }

    public void setIsShareCash(Byte isShareCash) {
        this.isShareCash = isShareCash;
    }

    public String getTopicIds() {
        return topicIds;
    }

    public void setTopicIds(String topicIds) {
        this.topicIds = topicIds;
    }

    public Integer getHotScore() {
        return hotScore;
    }

    public void setHotScore(Integer hotScore) {
        this.hotScore = hotScore;
    }

    public Long getOperator() {
        return operator;
    }

    public void setOperator(Long operator) {
        this.operator = operator;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}