package com.bxm.localnews.news.model.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@ApiModel("推荐池实体查询")
@Data
public class AdminMixRecommandParam extends PageParam {

    @ApiModelProperty("推荐池id")
    private Long id;

    @ApiModelProperty("来源 1：社区帖子 2：本地新闻 3：全国新闻")
    private String origin;

    @ApiModelProperty("投放区域")
    private String areaCode;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("定时推荐开始时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date recommendStartTime;

    @ApiModelProperty("定时推荐结束时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date recommendEndTime;

    @ApiModelProperty("作者")
    private String author;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("3.11.0 帖子类型，1：社区帖子，2：活动帖子")
    private Integer postType;

}
