package com.bxm.localnews.news.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

@ApiModel(description = "混合推荐池")
@Data
@Builder
public class AdminMixedRecommendPool {
    @ApiModelProperty("新闻或帖子id")
    private Long id;

    @ApiModelProperty("新闻或帖子标题")
    private String title;

    @ApiModelProperty("新闻或帖子投放地区")
    private String areaDetail;

    @ApiModelProperty("权重")
    private Integer weight;

    @ApiModelProperty("来源 1：社区帖子 2：本地新闻 3：全国新闻")
    private String origin;

    @ApiModelProperty("展示时间")
    private Date issueTime;

    @ApiModelProperty("添加时间")
    private Date addTime;

    @ApiModelProperty("修改时间")
    private Date modifyTime;

    @ApiModelProperty("状态 0：失效 1：可用   ")
    private Byte status;

    @ApiModelProperty("是否为自动加入推荐库 0：自动 1：人工 ")
    private Byte auto;

    @ApiModelProperty("定时展示时间")
    private Date publishTime;

    @ApiModelProperty("优化通知 0不发送, 1等待发送, 2已发送")
    private Byte optimizationNotice;

    @ApiModelProperty("定时推荐时间")
    private Date recommendTime;

    @ApiModelProperty("作者")
    private String author;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("发布区域类型0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("内容类型，1：社区帖子，2：活动帖子，3：小纸条，4：新闻,5:热文帖子")
    private Integer type;

    @Tolerate
    public AdminMixedRecommendPool() {
    }

}