package com.bxm.localnews.news.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

@Data
@ApiModel("马甲号概览信息")
@Builder
public class VirtualUserOverviewDTO {

    @Tolerate
    public VirtualUserOverviewDTO() {

    }

    @ApiModelProperty("马甲号id（即用户id）")
    private Long id;

    @ApiModelProperty("昵称")
    private String nickname;

    @ApiModelProperty("头像")
    private String headImg;

    @ApiModelProperty("马甲号用户信息，格式如：方仙女(女  单身，广德)")
    private String userInfo;
}
