package com.bxm.localnews.news.model.entity;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * t_news_publish_entry
 * @author
 */
@Data
public class NewsPublishEntry implements Serializable {
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 副标题
     */
    private String subTitle;

    /**
     * icon地址
     */
    private String iconUrl;

    /**
     * 跳转协议地址
     */
    private String protocol;

    /**
     * 1: 主要入口 2: 次要入口
     */
    private Byte level;

    /**
     * 0: 未启用 1: 已启用
     */
    private Byte status;

    /**
     * 0: 未删除 1: 已删除
     */
    private Byte deleteStatus;

    /**
     * 是否全国投放 0: 区域投放 1: 全国投放
     */
    private Byte globalStatus;

    private Date createTime;

    private Date modifyTime;

    private static final long serialVersionUID = 1L;
}