package com.bxm.localnews.news.model.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "新增新闻参数")
@Data
public class AdminNewsAddParam {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("频道id")
    private Integer kindId;

    @ApiModelProperty("作者")
    private String author;

    @ApiModelProperty("来源")
    private String source;

    @ApiModelProperty("页面展示发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date issueTime;

    @ApiModelProperty("生效时间")
    private Date publishTime;

    @ApiModelProperty("标签数组")
    private String showLevels;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("发布区域类型0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("地区编码数组")
    private String areaCodes;

    @ApiModelProperty("封面图片")
    private String coverList;

    @ApiModelProperty(value = "视频图片,如：" +
            "[\"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"," +
            " \"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"]")
    private String videoPosterList;

    @ApiModelProperty("属性标签")
    private String label;

    @ApiModelProperty("热门过期时间")
    private Date hotExpireTime;

    @ApiModelProperty("置顶过期时间")
    private Date topExpireTime;

    @ApiModelProperty("置顶")
    private Byte top;

    @ApiModelProperty("频道置顶")
    private Byte kindTop;

    @ApiModelProperty("热门")
    private Byte hot;

    @ApiModelProperty("状态")
    private Byte status;

    @ApiModelProperty("是否强引导下载  0:否 1:是")
    private Byte isBootDownload;

    @ApiModelProperty("状态 0：待审核  1：已拒绝  2：已通过  传2代表点击<通过>按钮审核通过")
    private Byte reviewStatus;

    @ApiModelProperty("编辑寄语id")
    private Long editorMessageId;

    @ApiModelProperty("编辑寄语名称")
    private String editorMessageName;

    @ApiModelProperty(value = "编辑寄语", hidden = true)
    private String editorMessage;

    @ApiModelProperty("启用占位符")
    private Byte enablePlaceholder;

    @ApiModelProperty("封面选择 0:只取图片 ,1:只取第一个视频 ,2:取内容详情的视频和图片  ")
    private Byte coverSelect;

}
