package com.bxm.localnews.news.model.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@ApiModel(description = "新闻参数")
public class AdminNewsReplyOriginalParam {
    /**
     * startTime :
     * endTime :
     * list : [{"content":"评论1"},{"content":"评论2"},{"content":"评论3"},{"content":"评论4"}]
     */
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date startTime;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date endTime;

    private List<Reply> list;

    private Long newsId;

    @ApiModelProperty("发布区域类型 0全国 1地方")
    private Integer deliveryType;

    private String areaCode;

    @ApiModelProperty("app端添加的用户id")
    private Long addAppUserId;

    public Long getAddAppUserId() {
        return addAppUserId;
    }

    public void setAddAppUserId(Long addAppUserId) {
        this.addAppUserId = addAppUserId;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Date getStartTime() {
        return startTime;
    }

    public AdminNewsReplyOriginalParam setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public Long getNewsId() {
        return newsId;
    }

    public AdminNewsReplyOriginalParam setNewsId(Long newsId) {
        this.newsId = newsId;
        return this;
    }

    public Date getEndTime() {
        return endTime;
    }

    public AdminNewsReplyOriginalParam setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<Reply> getList() {
        return list;
    }

    public void setList(List<Reply> list) {
        this.list = list;
    }

    @Data
    public static class Reply {
        /**
         * content : 评论1
         */

        private String content;

        /**
         * 虚拟用户id
         */
        private Long virtualUserId;

    }
}
