package com.bxm.localnews.news.model.param;

import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 现金账户处理参数
 *
 * @author Gonzo
 * @date 2020-05-07 17:34
 * @since 3.2.0
 */
@Data
public class CashAccountParam {

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 操作类型
     */
    private AccountActionEnum accountAction;

    /**
     * 流水类型
     */
    private CashFlowTypeEnum cashFlowType;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 业务关联id
     */
    private Long relationId;

    /**
     * 备注
     */
    private String remark;

}
