package com.bxm.localnews.news.model.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

@Data
@Builder
public class AdminNewsOverView {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("来源作者")
    private String author;

    @ApiModelProperty("分类id（一篇文章对应一个分类）")
    private Integer kindId;

    @ApiModelProperty("展示标签详情")
    private String showLevelDetail;

    @ApiModelProperty("发布时间")
    private Date publishTime;

    @ApiModelProperty("地址详情")
    private String areaDetail;

    @ApiModelProperty("新闻抓取时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty("新闻发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date issueTime;

    @ApiModelProperty("状态 0:抓取中 1：可用  2：失效")
    private Byte status;

    @ApiModelProperty("新闻类型  1：文章  2：组图  3：视频")
    private Byte type;

    @ApiModelProperty("新闻详情跳转地址")
    private String linkUrl;

    @ApiModelProperty("审核状态")
    private Byte reviewStatus;

    @ApiModelProperty("是否推荐  0:否  1是")
    private Byte isRecommend;

    @ApiModelProperty("发布区域类型0全国 1地方")
    private Integer deliveryType;

    @Tolerate
    public AdminNewsOverView() {
    }

}
